/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.OffscreenLayerOption;
import javax.media.nativewindow.OffscreenLayerSurface;
import javax.media.nativewindow.ToolkitLock;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NativeWindowFactoryImpl;

public abstract class NativeWindowFactory {
    protected static final boolean DEBUG;
    public static final String TYPE_EGL = "EGL";
    public static final String TYPE_WINDOWS = "Windows";
    public static final String TYPE_X11 = "X11";
    public static final String TYPE_ANDROID = "ANDROID";
    public static final String TYPE_MACOSX = "MacOSX";
    public static final String TYPE_AWT = "AWT";
    public static final String TYPE_DEFAULT = "default";
    private static NativeWindowFactory defaultFactory;
    private static Map<Class<?>, NativeWindowFactory> registeredFactories;
    private static Class<?> nativeWindowClass;
    private static String nativeWindowingTypePure;
    private static String nativeWindowingTypeCustom;
    private static boolean isAWTAvailable;
    private static final String JAWTUtilClassName = "jogamp.nativewindow.jawt.JAWTUtil";
    private static final String X11UtilClassName = "jogamp.nativewindow.x11.X11Util";
    private static final String OSXUtilClassName = "jogamp.nativewindow.macosx.OSXUtil";
    private static final String GDIClassName = "jogamp.nativewindow.windows.GDIUtil";
    private static ToolkitLock jawtUtilJAWTToolkitLock;
    public static final String AWTComponentClassName = "java.awt.Component";
    public static final String X11JAWTToolkitLockClassName = "jogamp.nativewindow.jawt.x11.X11JAWTToolkitLock";
    public static final String X11ToolkitLockClassName = "jogamp.nativewindow.x11.X11ToolkitLock";
    private static Class<?> x11JAWTToolkitLockClass;
    private static Constructor<?> x11JAWTToolkitLockConstructor;
    private static Class<?> x11ToolkitLockClass;
    private static Constructor<?> x11ToolkitLockConstructor;
    private static boolean isFirstUIActionOnProcess;
    private static boolean requiresToolkitLock;
    static boolean initialized;

    protected NativeWindowFactory() {
    }

    private static String _getNativeWindowingType() {
        switch (Platform.OS_TYPE) {
            case ANDROID: {
                return TYPE_ANDROID;
            }
            case MACOS: {
                return TYPE_MACOSX;
            }
            case WINDOWS: {
                return TYPE_WINDOWS;
            }
            case OPENKODE: {
                return TYPE_EGL;
            }
        }
        return TYPE_X11;
    }

    private static void initSingletonNativeImpl(boolean bl, ClassLoader classLoader) {
        isFirstUIActionOnProcess = bl;
        String string = TYPE_X11.equals(nativeWindowingTypePure) ? X11UtilClassName : (TYPE_WINDOWS.equals(nativeWindowingTypePure) ? GDIClassName : (TYPE_MACOSX.equals(nativeWindowingTypePure) ? OSXUtilClassName : null));
        if (null != string) {
            ReflectionUtil.callStaticMethod(string, "initSingleton", new Class[]{Boolean.TYPE}, new Object[]{new Boolean(bl)}, classLoader);
            Boolean bl2 = (Boolean)ReflectionUtil.callStaticMethod(string, "requiresToolkitLock", null, null, classLoader);
            requiresToolkitLock = bl2;
        } else {
            requiresToolkitLock = false;
        }
    }

    public static synchronized void initSingleton(boolean bl) {
        if (!initialized) {
            Method[] methodArray;
            initialized = true;
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - NativeWindowFactory.initSingleton(" + bl + ")");
            }
            ClassLoader classLoader = NativeWindowFactory.class.getClassLoader();
            nativeWindowingTypePure = NativeWindowFactory._getNativeWindowingType();
            String string = Debug.getProperty("nativewindow.ws.name", true);
            nativeWindowingTypeCustom = null == string || string.length() == 0 ? nativeWindowingTypePure : string;
            if (bl) {
                NativeWindowFactory.initSingletonNativeImpl(true, classLoader);
            }
            isAWTAvailable = false;
            if (!Debug.getBooleanProperty("java.awt.headless", true) && ReflectionUtil.isClassAvailable(AWTComponentClassName, classLoader) && ReflectionUtil.isClassAvailable("com.jogamp.nativewindow.awt.AWTGraphicsDevice", classLoader) && null != (methodArray = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    try {
                        Class<?> clazz = Class.forName(NativeWindowFactory.JAWTUtilClassName, true, NativeWindowFactory.class.getClassLoader());
                        Method method = clazz.getDeclaredMethod("isHeadlessMode", null);
                        method.setAccessible(true);
                        Method method2 = clazz.getDeclaredMethod("initSingleton", null);
                        method2.setAccessible(true);
                        Method method3 = clazz.getDeclaredMethod("getJAWTToolkitLock", new Class[0]);
                        method3.setAccessible(true);
                        return new Method[]{method2, method, method3};
                    }
                    catch (Exception exception) {
                        if (DEBUG) {
                            exception.printStackTrace();
                        }
                        return null;
                    }
                }
            }))) {
                Method method = methodArray[0];
                Method method2 = methodArray[1];
                Method method3 = methodArray[2];
                ReflectionUtil.callMethod(null, method, new Object[0]);
                Object object = ReflectionUtil.callMethod(null, method2, new Object[0]);
                if (!(object instanceof Boolean)) {
                    throw new RuntimeException("JAWTUtil.isHeadlessMode() didn't return a Boolean");
                }
                isAWTAvailable = ((Boolean)object).equals(Boolean.FALSE);
                object = ReflectionUtil.callMethod(null, method3, new Object[0]);
                if (object instanceof ToolkitLock) {
                    jawtUtilJAWTToolkitLock = (ToolkitLock)object;
                } else {
                    throw new RuntimeException("JAWTUtil.getJAWTToolkitLock() didn't return a ToolkitLock");
                }
            }
            if (!bl) {
                NativeWindowFactory.initSingletonNativeImpl(false, classLoader);
            }
            registeredFactories = Collections.synchronizedMap(new HashMap());
            methodArray = new NativeWindowFactoryImpl();
            nativeWindowClass = NativeWindow.class;
            NativeWindowFactory.registerFactory(nativeWindowClass, (NativeWindowFactory)methodArray);
            defaultFactory = methodArray;
            if (isAWTAvailable) {
                NativeWindowFactory.registerFactory(ReflectionUtil.getClass(AWTComponentClassName, false, classLoader), (NativeWindowFactory)methodArray);
            }
            if (TYPE_X11 == nativeWindowingTypePure) {
                x11ToolkitLockClass = ReflectionUtil.getClass(X11ToolkitLockClassName, false, classLoader);
                x11ToolkitLockConstructor = ReflectionUtil.getConstructor(x11ToolkitLockClass, Long.TYPE);
                if (NativeWindowFactory.isAWTAvailable()) {
                    x11JAWTToolkitLockClass = ReflectionUtil.getClass(X11JAWTToolkitLockClassName, false, classLoader);
                    x11JAWTToolkitLockConstructor = ReflectionUtil.getConstructor(x11JAWTToolkitLockClass, Long.TYPE);
                }
            }
            if (DEBUG) {
                System.err.println("NativeWindowFactory firstUIActionOnProcess " + bl);
                System.err.println("NativeWindowFactory requiresToolkitLock " + requiresToolkitLock);
                System.err.println("NativeWindowFactory isAWTAvailable " + isAWTAvailable + ", defaultFactory " + methodArray);
            }
            GraphicsConfigurationFactory.initSingleton();
        }
    }

    public static synchronized void shutdown() {
        if (initialized) {
            initialized = false;
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - NativeWindowFactory.shutdown() START");
            }
            registeredFactories.clear();
            registeredFactories = null;
            GraphicsConfigurationFactory.shutdown();
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - NativeWindowFactory.shutdown() END");
            }
        }
    }

    public static boolean isFirstUIActionOnProcess() {
        return isFirstUIActionOnProcess;
    }

    public static boolean requiresToolkitLock() {
        return requiresToolkitLock;
    }

    public static boolean isAWTAvailable() {
        return isAWTAvailable;
    }

    public static String getNativeWindowType(boolean bl) {
        return bl ? nativeWindowingTypeCustom : nativeWindowingTypePure;
    }

    public static void setDefaultFactory(NativeWindowFactory nativeWindowFactory) {
        defaultFactory = nativeWindowFactory;
    }

    public static NativeWindowFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static ToolkitLock getDefaultToolkitLock() {
        return NativeWindowFactory.getDefaultToolkitLock(NativeWindowFactory.getNativeWindowType(false));
    }

    public static ToolkitLock getDefaultToolkitLock(String string) {
        if (NativeWindowFactory.requiresToolkitLock() && TYPE_AWT == string && TYPE_X11 == NativeWindowFactory.getNativeWindowType(false) && NativeWindowFactory.isAWTAvailable()) {
            return NativeWindowFactory.getAWTToolkitLock();
        }
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    public static ToolkitLock getAWTToolkitLock() {
        return jawtUtilJAWTToolkitLock;
    }

    public static ToolkitLock getNullToolkitLock() {
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    public static ToolkitLock createDefaultToolkitLock(String string, long l) {
        if (NativeWindowFactory.requiresToolkitLock() && TYPE_X11 == string) {
            if (0L == l) {
                throw new RuntimeException("JAWTUtil.createDefaultToolkitLock() called with NULL device but on X11");
            }
            return NativeWindowFactory.createX11ToolkitLock(l);
        }
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    public static ToolkitLock createDefaultToolkitLock(String string, String string2, long l) {
        if (NativeWindowFactory.requiresToolkitLock() && TYPE_X11 == string) {
            if (0L == l) {
                throw new RuntimeException("JAWTUtil.createDefaultToolkitLock() called with NULL device but on X11");
            }
            if (TYPE_AWT == string2 && NativeWindowFactory.isAWTAvailable()) {
                return NativeWindowFactory.createX11AWTToolkitLock(l);
            }
            return NativeWindowFactory.createX11ToolkitLock(l);
        }
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    protected static ToolkitLock createX11AWTToolkitLock(long l) {
        try {
            if (DEBUG) {
                System.err.println("NativeWindowFactory.createX11AWTToolkitLock(0x" + Long.toHexString(l) + ")");
            }
            return (ToolkitLock)x11JAWTToolkitLockConstructor.newInstance(new Long(l));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected static ToolkitLock createX11ToolkitLock(long l) {
        try {
            return (ToolkitLock)x11ToolkitLockConstructor.newInstance(new Long(l));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static NativeWindowFactory getFactory(Class<?> clazz) throws IllegalArgumentException {
        if (nativeWindowClass.isAssignableFrom(clazz)) {
            return registeredFactories.get(nativeWindowClass);
        }
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            NativeWindowFactory nativeWindowFactory = registeredFactories.get(clazz2);
            if (nativeWindowFactory == null) continue;
            return nativeWindowFactory;
        }
        throw new IllegalArgumentException("No registered NativeWindowFactory for class " + clazz.getName());
    }

    protected static void registerFactory(Class<?> clazz, NativeWindowFactory nativeWindowFactory) {
        if (DEBUG) {
            System.err.println("NativeWindowFactory.registerFactory() " + clazz + " -> " + nativeWindowFactory);
        }
        registeredFactories.put(clazz, nativeWindowFactory);
    }

    public static NativeWindow getNativeWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) throws IllegalArgumentException, NativeWindowException {
        if (object == null) {
            throw new IllegalArgumentException("Null window object");
        }
        return NativeWindowFactory.getFactory(object.getClass()).getNativeWindowImpl(object, abstractGraphicsConfiguration);
    }

    protected abstract NativeWindow getNativeWindowImpl(Object var1, AbstractGraphicsConfiguration var2) throws IllegalArgumentException;

    public static OffscreenLayerSurface getOffscreenLayerSurface(NativeSurface nativeSurface, boolean bl) {
        if (nativeSurface instanceof OffscreenLayerSurface && (!bl || nativeSurface instanceof OffscreenLayerOption)) {
            OffscreenLayerSurface offscreenLayerSurface = (OffscreenLayerSurface)((Object)nativeSurface);
            return !bl || ((OffscreenLayerOption)((Object)offscreenLayerSurface)).isOffscreenLayerSurfaceEnabled() ? offscreenLayerSurface : null;
        }
        if (nativeSurface instanceof NativeWindow) {
            for (NativeWindow nativeWindow = ((NativeWindow)nativeSurface).getParent(); null != nativeWindow; nativeWindow = nativeWindow.getParent()) {
                if (!(nativeWindow instanceof OffscreenLayerSurface) || bl && !(nativeWindow instanceof OffscreenLayerOption)) continue;
                OffscreenLayerSurface offscreenLayerSurface = (OffscreenLayerSurface)((Object)nativeWindow);
                return !bl || ((OffscreenLayerOption)((Object)offscreenLayerSurface)).isOffscreenLayerSurfaceEnabled() ? offscreenLayerSurface : null;
            }
        }
        return null;
    }

    static {
        Platform.initSingleton();
        DEBUG = Debug.debug("NativeWindow");
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - Info: NativeWindowFactory.<init>");
        }
        initialized = false;
    }
}

