/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import jogamp.graph.font.typecast.ot.table.CmapFormat;
import jogamp.graph.font.typecast.ot.table.CmapIndexEntry;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.Table;

public class CmapTable
implements Table {
    private DirectoryEntry _de;
    private int _version;
    private int _numTables;
    private CmapIndexEntry[] _entries;

    protected CmapTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        int n;
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._version = dataInput.readUnsignedShort();
        this._numTables = dataInput.readUnsignedShort();
        long l = 4L;
        this._entries = new CmapIndexEntry[this._numTables];
        for (n = 0; n < this._numTables; ++n) {
            this._entries[n] = new CmapIndexEntry(dataInput);
            l += 8L;
        }
        Arrays.sort(this._entries);
        n = 0;
        CmapFormat cmapFormat = null;
        for (int i = 0; i < this._numTables; ++i) {
            if (this._entries[i].getOffset() == n) {
                this._entries[i].setFormat(cmapFormat);
                continue;
            }
            if ((long)this._entries[i].getOffset() > l) {
                dataInput.skipBytes(this._entries[i].getOffset() - (int)l);
            } else if ((long)this._entries[i].getOffset() != l) {
                throw new IOException();
            }
            int n2 = dataInput.readUnsignedShort();
            cmapFormat = CmapFormat.create(n2, dataInput);
            n = this._entries[i].getOffset();
            this._entries[i].setFormat(cmapFormat);
            l += (long)cmapFormat.getLength();
        }
    }

    public int getVersion() {
        return this._version;
    }

    public int getNumTables() {
        return this._numTables;
    }

    public CmapIndexEntry getCmapIndexEntry(int n) {
        return this._entries[n];
    }

    public CmapFormat getCmapFormat(short s, short s2) {
        for (int i = 0; i < this._numTables; ++i) {
            if (this._entries[i].getPlatformId() != s || this._entries[i].getEncodingId() != s2) continue;
            return this._entries[i].getFormat();
        }
        return null;
    }

    @Override
    public int getType() {
        return 1668112752;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("cmap\n");
        for (int i = 0; i < this._numTables; ++i) {
            stringBuffer.append("\t").append(this._entries[i].toString()).append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }
}

