/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.macosx;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.util.ScreenModeUtil;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.util.Dimension;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.Point;
import jogamp.newt.ScreenImpl;
import jogamp.newt.driver.macosx.MacDisplay;

public class MacScreen
extends ScreenImpl {
    private static IntObjectHashMap scrnIdx2Dimension;
    private int nativeModeIdx;

    @Override
    protected void createNativeImpl() {
        this.aScreen = new DefaultGraphicsScreen(this.getDisplay().getGraphicsDevice(), this.screen_idx);
    }

    @Override
    protected void closeNativeImpl() {
    }

    private static native int getWidthImpl0(int var0);

    private static native int getHeightImpl0(int var0);

    private int[] getScreenModeIdx(int n) {
        int[] nArray;
        DimensionImmutable dimensionImmutable = (DimensionImmutable)scrnIdx2Dimension.get(this.screen_idx);
        if (null == dimensionImmutable) {
            nArray = this.getScreenSizeMM0(this.screen_idx);
            if (null == nArray || 0 == nArray.length) {
                return null;
            }
            dimensionImmutable = new Dimension(nArray[0], nArray[1]);
            scrnIdx2Dimension.put(this.screen_idx, dimensionImmutable);
        }
        if (null == (nArray = this.getScreenMode0(this.screen_idx, n, dimensionImmutable.getWidth(), dimensionImmutable.getHeight())) || 0 == nArray.length) {
            return null;
        }
        if (nArray.length < 8) {
            throw new RuntimeException("properties array too short, should be >= 8, is " + nArray.length);
        }
        return nArray;
    }

    @Override
    protected int[] getScreenModeFirstImpl() {
        this.nativeModeIdx = 0;
        return this.getScreenModeNextImpl();
    }

    @Override
    protected int[] getScreenModeNextImpl() {
        int[] nArray = this.getScreenModeIdx(this.nativeModeIdx);
        if (null != nArray && 0 < nArray.length) {
            ++this.nativeModeIdx;
            return nArray;
        }
        return null;
    }

    @Override
    protected ScreenMode getCurrentScreenModeImpl() {
        int[] nArray = this.getScreenModeIdx(-1);
        if (null != nArray && 0 < nArray.length) {
            return ScreenModeUtil.streamIn(nArray, 0);
        }
        return null;
    }

    @Override
    protected boolean setCurrentScreenModeImpl(ScreenMode screenMode) {
        ArrayHashSet<ScreenMode> arrayHashSet = this.getScreenModesOrig();
        int n = arrayHashSet.indexOf(screenMode);
        if (0 > n) {
            throw new RuntimeException("ScreenMode not element of ScreenMode list: " + screenMode);
        }
        int n2 = this.getScreenModesIdx2NativeIdx().get(n);
        return this.setScreenMode0(this.screen_idx, n2);
    }

    @Override
    protected int validateScreenIndex(int n) {
        return n;
    }

    @Override
    protected void getVirtualScreenOriginAndSize(Point point, Dimension dimension) {
        point.setX(0);
        point.setY(0);
        dimension.setWidth(MacScreen.getWidthImpl0(this.screen_idx));
        dimension.setHeight(MacScreen.getHeightImpl0(this.screen_idx));
    }

    private native int[] getScreenSizeMM0(int var1);

    private native int[] getScreenMode0(int var1, int var2, int var3, int var4);

    private native boolean setScreenMode0(int var1, int var2);

    static {
        MacDisplay.initSingleton();
        scrnIdx2Dimension = new IntObjectHashMap();
        scrnIdx2Dimension.setKeyNotFoundValue(null);
    }
}

