/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.awt;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLException;
import jogamp.opengl.GLWorkerThread;
import jogamp.opengl.ThreadingImpl;
import jogamp.opengl.ThreadingPlugin;
import jogamp.opengl.awt.Java2D;

public class AWTThreadingPlugin
implements ThreadingPlugin {
    @Override
    public boolean isOpenGLThread() throws GLException {
        switch (ThreadingImpl.getMode()) {
            case ST_AWT: {
                if (Java2D.isOGLPipelineActive() && !ThreadingImpl.isX11()) {
                    return Java2D.isQueueFlusherThread();
                }
                return EventQueue.isDispatchThread();
            }
            case ST_WORKER: {
                if (Java2D.isOGLPipelineActive()) {
                    return Java2D.isQueueFlusherThread() || ThreadingImpl.isX11() && GLWorkerThread.isWorkerThread();
                }
                return GLWorkerThread.isWorkerThread();
            }
        }
        throw new InternalError("Illegal single-threading mode " + (Object)((Object)ThreadingImpl.getMode()));
    }

    @Override
    public void invokeOnOpenGLThread(Runnable runnable) throws GLException {
        switch (ThreadingImpl.getMode()) {
            case ST_AWT: {
                if (Java2D.isOGLPipelineActive() && !ThreadingImpl.isX11()) {
                    Java2D.invokeWithOGLContextCurrent(null, runnable);
                    break;
                }
                try {
                    EventQueue.invokeAndWait(runnable);
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new GLException(invocationTargetException.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    throw new GLException(interruptedException);
                }
            }
            case ST_WORKER: {
                GLWorkerThread.start();
                try {
                    GLWorkerThread.invokeAndWait(runnable);
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new GLException(invocationTargetException.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    throw new GLException(interruptedException);
                }
            }
            default: {
                throw new InternalError("Illegal single-threading mode " + (Object)((Object)ThreadingImpl.getMode()));
            }
        }
    }
}

