/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.VisualIDHolder;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class EGLGLCapabilities
extends GLCapabilities {
    private final long eglcfg;
    private final int eglcfgid;
    private final int renderableType;
    private final int nativeVisualID;

    public EGLGLCapabilities(long l, int n, int n2, GLProfile gLProfile, int n3) {
        super(null != gLProfile ? gLProfile : EGLGLCapabilities.getCompatible(n3));
        this.eglcfg = l;
        this.eglcfgid = n;
        if (!EGLGLCapabilities.isCompatible(gLProfile, n3)) {
            throw new GLException("Incompatible " + gLProfile + " with EGL-RenderableType[" + EGLGLCapabilities.renderableTypeToString(null, n3) + "]");
        }
        this.renderableType = n3;
        this.nativeVisualID = n2;
    }

    @Override
    public Object cloneMutable() {
        return this.clone();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (RuntimeException runtimeException) {
            throw new GLException(runtimeException);
        }
    }

    public final long getEGLConfig() {
        return this.eglcfg;
    }

    public final int getEGLConfigID() {
        return this.eglcfgid;
    }

    public final int getRenderableType() {
        return this.renderableType;
    }

    public final int getNativeVisualID() {
        return this.nativeVisualID;
    }

    @Override
    public final int getVisualID(VisualIDHolder.VIDType vIDType) throws NativeWindowException {
        switch (vIDType) {
            case INTRINSIC: 
            case EGL_CONFIG: {
                return this.getEGLConfigID();
            }
            case NATIVE: {
                return this.getNativeVisualID();
            }
        }
        throw new NativeWindowException("Invalid type <" + (Object)((Object)vIDType) + ">");
    }

    public static boolean isCompatible(GLProfile gLProfile, int n) {
        if (null == gLProfile) {
            return true;
        }
        if (0 != (n & 1) && gLProfile.usesNativeGLES1()) {
            return true;
        }
        if (0 != (n & 4) && gLProfile.usesNativeGLES2()) {
            return true;
        }
        return 0 != (n & 8) && !gLProfile.usesNativeGLES();
    }

    public static GLProfile getCompatible(int n) {
        if (0 != (n & 4) && GLProfile.isAvailable("GLES2")) {
            return GLProfile.get("GLES2");
        }
        if (0 != (n & 1) && GLProfile.isAvailable("GLES1")) {
            return GLProfile.get("GLES1");
        }
        if (0 != (n & 8)) {
            return GLProfile.getDefault();
        }
        return null;
    }

    public static StringBuffer renderableTypeToString(StringBuffer stringBuffer, int n) {
        if (null == stringBuffer) {
            stringBuffer = new StringBuffer();
        }
        boolean bl = true;
        if (0 != (n & 8)) {
            stringBuffer.append("GL");
            bl = false;
        }
        if (0 != (n & 1)) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("GLES1");
            bl = false;
        }
        if (0 != (n & 4)) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("GLES2");
            bl = false;
        }
        if (0 != (n & 0x30A1)) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("VG");
            bl = false;
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer toString(StringBuffer stringBuffer) {
        if (null == stringBuffer) {
            stringBuffer = new StringBuffer();
        }
        stringBuffer.append("egl cfg 0x").append(Integer.toHexString(this.eglcfgid));
        stringBuffer.append(", vid 0x").append(Integer.toHexString(this.nativeVisualID)).append(": ");
        super.toString(stringBuffer);
        stringBuffer.append(", [");
        EGLGLCapabilities.renderableTypeToString(stringBuffer, this.renderableType);
        return stringBuffer.append("]");
    }
}

