/*
 * Decompiled with CFR 0.152.
 */
package saito.objloader;

import java.util.ArrayList;
import java.util.Comparator;
import processing.core.PConstants;
import processing.core.PVector;

public class Face
implements PConstants,
Comparable {
    public int indexType = 20;
    public ArrayList<Integer> vertexIndices = new ArrayList();
    public ArrayList<Integer> uvIndices = new ArrayList();
    public ArrayList<Integer> normalIndices = new ArrayList();
    public ArrayList<PVector> vertices = new ArrayList();
    public ArrayList<PVector> normals = new ArrayList();
    public ArrayList<PVector> uvs = new ArrayList();
    public static Comparator<Face> FaceXComparator = new Comparator<Face>(){

        @Override
        public int compare(Face f1, Face f2) {
            PVector f1Center = f1.getCenter();
            PVector f2Center = f2.getCenter();
            return (int)(f1Center.x - f2Center.x);
        }
    };
    public static Comparator<Face> FaceYComparator = new Comparator<Face>(){

        @Override
        public int compare(Face f1, Face f2) {
            PVector f1Center = f1.getCenter();
            PVector f2Center = f2.getCenter();
            return (int)(f1Center.y - f2Center.y);
        }
    };
    public static Comparator<Face> FaceZComparator = new Comparator<Face>(){

        @Override
        public int compare(Face f1, Face f2) {
            PVector f1Center = f1.getCenter();
            PVector f2Center = f2.getCenter();
            return (int)(f1Center.z - f2Center.z);
        }
    };

    public int getVertIndexCount() {
        return this.vertexIndices.size();
    }

    public int getNormIndexCount() {
        return this.normalIndices.size();
    }

    public int getUVIndexCount() {
        return this.uvIndices.size();
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    public int getNormalCount() {
        return this.normals.size();
    }

    public int getUVCount() {
        return this.uvs.size();
    }

    public int[] getVertexIndices() {
        int[] v = new int[this.getVertIndexCount()];
        int i = 0;
        while (i < v.length) {
            v[i] = this.getVertexIndex(i);
            ++i;
        }
        return v;
    }

    public int[] getNormalIndices() {
        int[] v = new int[this.getNormIndexCount()];
        int i = 0;
        while (i < v.length) {
            v[i] = this.getNormalIndex(i);
            ++i;
        }
        return v;
    }

    public int[] getTextureIndices() {
        int[] v = new int[this.getUVIndexCount()];
        int i = 0;
        while (i < v.length) {
            v[i] = this.getTextureIndex(i);
            ++i;
        }
        return v;
    }

    public PVector[] getVertices() {
        return this.vertices.toArray(new PVector[this.vertices.size()]);
    }

    public PVector[] getNormals() {
        return this.normals.toArray(new PVector[this.normals.size()]);
    }

    public PVector[] getUvs() {
        return this.uvs.toArray(new PVector[this.uvs.size()]);
    }

    public PVector getCenter() {
        PVector c = new PVector();
        int i = 0;
        while (i < this.vertices.size()) {
            c.add(this.vertices.get(i));
            ++i;
        }
        c.div(this.vertices.size());
        return c;
    }

    public PVector getNormal() {
        PVector c = this.getCenter();
        PVector aToB = PVector.sub(c, this.vertices.get(0));
        PVector cToB = PVector.sub(c, this.vertices.get(this.vertices.size() - 1));
        PVector n = cToB.cross(aToB);
        n.normalize();
        n.mult(-1.0f);
        return n;
    }

    public int getVertexIndex(int i) {
        return this.vertexIndices.get(i) - 1;
    }

    public int getTextureIndex(int i) {
        return this.uvIndices.get(i) - 1;
    }

    public int getNormalIndex(int i) {
        return this.normalIndices.get(i) - 1;
    }

    public boolean isFacingPosition(PVector position) {
        PVector c = this.getCenter();
        PVector positionToFace = new PVector(position.x - c.x, position.y - c.y, position.z - c.z);
        float result = positionToFace.dot(this.getNormal());
        return result < 0.0f;
    }

    public float getFacingAmount(PVector position) {
        PVector c = this.getCenter();
        PVector positionToFace = new PVector(position.x - c.x, position.y - c.y, position.z - c.z);
        c.normalize();
        positionToFace.normalize();
        return 1.0f - (positionToFace.dot(this.getNormal()) + 1.0f) / 2.0f;
    }

    public int compareTo(Object f2) throws ClassCastException {
        if (!(f2 instanceof Face)) {
            throw new ClassCastException("Face object expected.");
        }
        PVector f1Center = this.getCenter();
        PVector f2Center = ((Face)f2).getCenter();
        return (int)(f1Center.x - f2Center.x);
    }
}

