/*
 * Decompiled with CFR 0.152.
 */
package saito.objloader;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.media.opengl.GL;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;
import processing.opengl.PGraphicsOpenGL;
import saito.objloader.BoundingBox;
import saito.objloader.Debug;
import saito.objloader.Face;
import saito.objloader.Group;
import saito.objloader.Material;
import saito.objloader.Segment;

public class OBJModel {
    private ArrayList<PVector> vertices;
    private ArrayList<PVector> textureVertices;
    private ArrayList<PVector> normalVertices;
    private ArrayList<Segment> segments;
    private Hashtable<String, Material> materials;
    private Hashtable<String, Group> groups;
    private String name = "default";
    private String defaultMaterialName = "default";
    private Group defaultGroup = new Group("default");
    private Segment defaultSegment = new Segment();
    private PApplet parent;
    private PImage texture;
    private int drawMode = 9;
    private boolean useTexture = true;
    private boolean useMaterial = true;
    public static String RELATIVE = "relative";
    public static String ABSOLUTE = "absolute";
    private String texturePathMode = RELATIVE;
    public Debug debug;
    private String originalTexture;
    private GL gl;

    public OBJModel(PApplet _parent) {
        this.setup(_parent);
    }

    public OBJModel(PApplet _parent, String _filename) {
        this.setup(_parent);
        this.load(_filename);
    }

    public OBJModel(PApplet _parent, String _fileName, int _shapeMode) {
        this.setup(_parent);
        this.shapeMode(_shapeMode);
        this.load(_fileName);
    }

    public OBJModel(PApplet _parent, String _fileName, String _texturePathMode) {
        this.setup(_parent);
        this.texturePathMode = _texturePathMode.toLowerCase();
        this.load(_fileName);
    }

    public OBJModel(PApplet _parent, String _fileName, String _texturePathMode, int _shapeMode) {
        this.setup(_parent);
        this.texturePathMode = _texturePathMode.toLowerCase();
        this.shapeMode(_shapeMode);
        this.load(_fileName);
    }

    private void setup(PApplet parent) {
        this.parent = parent;
        this.vertices = new ArrayList();
        this.segments = new ArrayList();
        this.textureVertices = new ArrayList();
        this.normalVertices = new ArrayList();
        this.groups = new Hashtable();
        this.materials = new Hashtable();
        this.debug = new Debug(parent);
        this.debug.enabled = true;
    }

    public void setupGL() {
        if (!(this.parent.g instanceof PGraphicsOpenGL)) {
            throw new RuntimeException("This feature requires OpenGL");
        }
        this.gl = ((PGraphicsOpenGL)this.parent.g).gl;
        this.debug.println("Setting up OPENGL buffers");
        this.debug.println("Generating Buffers");
        this.debug.println("number of model segments = " + this.segments.size());
        int i = 0;
        while (i < this.segments.size()) {
            Segment tmpModelSegment = this.segments.get(i);
            if (tmpModelSegment.getFaceCount() != 0) {
                this.debug.println("number of model elements = " + tmpModelSegment.getFaceCount());
                this.debug.println("model element uses this mtl = " + tmpModelSegment.getMaterialName());
                PVector[] vs = this.vertices.toArray(new PVector[this.vertices.size()]);
                PVector[] tVs = this.textureVertices.toArray(new PVector[this.textureVertices.size()]);
                PVector[] nVs = this.normalVertices.toArray(new PVector[this.normalVertices.size()]);
                tmpModelSegment.setupGL(this.gl, this.debug, vs, tVs, nVs);
                Material mtl = this.materials.get(tmpModelSegment.materialName);
                mtl.setupGL(this.gl, this.debug);
            }
            ++i;
        }
        this.debug.println("leaving setup function");
    }

    public void drawGL() {
        boolean fill = this.parent.g.fill;
        boolean stroke = this.parent.g.stroke;
        this.parent.fill(255);
        this.parent.stroke(255);
        this.parent.noFill();
        this.parent.noStroke();
        this.gl = ((PGraphicsOpenGL)this.parent.g).beginGL();
        this.saveGLState();
        int i = 0;
        while (i < this.segments.size()) {
            Segment tmpModelSegment = this.segments.get(i);
            if (tmpModelSegment.getFaceCount() != 0) {
                Material mtl = this.materials.get(tmpModelSegment.materialName);
                mtl.beginDrawGL(this.gl, this.useMaterial, this.useTexture);
                switch (this.drawMode) {
                    case 2: {
                        tmpModelSegment.drawGL(this.gl, 0);
                        break;
                    }
                    case 4: {
                        tmpModelSegment.drawGL(this.gl, 1);
                        break;
                    }
                    case 9: {
                        tmpModelSegment.drawGL(this.gl, 4);
                        break;
                    }
                    case 10: {
                        tmpModelSegment.drawGL(this.gl, 5);
                        break;
                    }
                    case 16: {
                        tmpModelSegment.drawGL(this.gl, 7);
                        break;
                    }
                    case 17: {
                        tmpModelSegment.drawGL(this.gl, 8);
                        break;
                    }
                    case 20: {
                        tmpModelSegment.drawGL(this.gl, 9);
                    }
                }
                mtl.endDrawGL(this.gl, this.useMaterial, this.useTexture);
            }
            ++i;
        }
        this.revertGLState();
        ((PGraphicsOpenGL)this.parent.g).endGL();
        this.parent.g.fill = fill;
        this.parent.g.stroke = stroke;
    }

    private void saveGLState() {
        this.gl.glPushAttrib(1048575);
        this.gl.glMatrixMode(5888);
        this.gl.glPushMatrix();
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
    }

    private void revertGLState() {
        this.gl.glMatrixMode(5889);
        this.gl.glPopMatrix();
        this.gl.glMatrixMode(5888);
        this.gl.glPopMatrix();
        this.gl.glPopAttrib();
    }

    public void printModelInfo() {
        this.debug.println("Obj Name: \t\t" + this.name);
        this.debug.println("");
        this.debug.println("V  Size: \t\t" + this.vertices.size());
        this.debug.println("Vt Size: \t\t" + this.textureVertices.size());
        this.debug.println("Vn Size: \t\t" + this.normalVertices.size());
        this.debug.println("G  Size: \t\t" + this.groups.size());
        this.debug.println("S  Size: \t\t" + this.getSegmentCount());
        this.debug.println("");
    }

    public void enableDebug() {
        this.debug.enabled = true;
        this.debug.println("");
        this.debug.println("objloader version 021");
        this.debug.println("18 August 2010");
        this.debug.println("http://code.google.com/p/saitoobjloader/");
        this.debug.println("");
    }

    public void disableDebug() {
        this.debug.enabled = false;
    }

    public void reset() {
        this.vertices.clear();
        this.textureVertices.clear();
        this.normalVertices.clear();
        this.groups.clear();
        this.segments.clear();
        this.materials.clear();
        this.originalTexture();
        this.debug.println("OBJModel is empty");
    }

    public void disableTexture() {
        this.useTexture = false;
        this.debug.println("texture:\t\t" + this.useTexture);
    }

    public void enableTexture() {
        this.useTexture = true;
        this.debug.println("texture:\t\t" + this.useTexture);
    }

    public void disableMaterial() {
        this.useMaterial = false;
        this.debug.println("material:\t\toff");
    }

    public void enableMaterial() {
        this.useMaterial = true;
        this.debug.println("material:\t\ton");
    }

    public void shapeMode(int mode) {
        this.drawMode = mode;
        switch (mode) {
            case 2: {
                this.debug.println("draw mode:\t\tPOINTS");
                break;
            }
            case 4: {
                this.debug.println("draw mode:\t\tLINES");
                break;
            }
            case 20: {
                this.debug.println("draw mode:\t\tPOLYGON");
                break;
            }
            case 9: {
                this.debug.println("draw mode:\t\tTRIANGLES");
                break;
            }
            case 10: {
                this.debug.println("draw mode:\t\tTRIANGLE_STRIP");
                break;
            }
            case 16: {
                this.debug.println("draw mode:\t\tQUADS");
                break;
            }
            case 17: {
                this.debug.println("draw mode:\t\t");
            }
        }
    }

    public void draw() {
        this.drawModel();
    }

    private void drawModel() {
        try {
            PVector v = null;
            PVector vt = null;
            PVector vn = null;
            Material tmpMaterial = null;
            int s = 0;
            while (s < this.getSegmentCount()) {
                Segment tmpModelSegment = this.segments.get(s);
                tmpMaterial = this.materials.get(tmpModelSegment.materialName);
                if (tmpMaterial == null) {
                    tmpMaterial = this.materials.get(this.defaultMaterialName);
                    this.debug.println("Material '" + tmpModelSegment.materialName + "' not defined");
                }
                if (this.useMaterial) {
                    this.parent.ambient(255.0f * tmpMaterial.Ka[0], 255.0f * tmpMaterial.Ka[1], 255.0f * tmpMaterial.Ka[2]);
                    this.parent.specular(255.0f * tmpMaterial.Ks[0], 255.0f * tmpMaterial.Ks[1], 255.0f * tmpMaterial.Ks[2]);
                    this.parent.fill(255.0f * tmpMaterial.Kd[0], 255.0f * tmpMaterial.Kd[1], 255.0f * tmpMaterial.Kd[2], 255.0f * tmpMaterial.d);
                }
                int f = 0;
                while (f < tmpModelSegment.getFaceCount()) {
                    Face tmpModelElement = tmpModelSegment.getFace(f);
                    if (tmpModelElement.getVertIndexCount() > 0) {
                        this.parent.textureMode(1);
                        this.parent.beginShape(this.drawMode);
                        if (!this.useTexture || tmpMaterial.map_Kd == null) {
                            this.useTexture = false;
                        }
                        if (this.useTexture) {
                            if (this.texture != null) {
                                this.parent.texture(this.texture);
                            } else {
                                this.parent.texture(tmpMaterial.map_Kd);
                            }
                        }
                        int fp = 0;
                        while (fp < tmpModelElement.getVertIndexCount()) {
                            block18: {
                                v = this.vertices.get(tmpModelElement.getVertexIndex(fp));
                                if (v != null) {
                                    try {
                                        if (tmpModelElement.normalIndices.size() > 0) {
                                            vn = this.normalVertices.get(tmpModelElement.getNormalIndex(fp));
                                            this.parent.normal(vn.x, vn.y, vn.z);
                                        }
                                        if (this.useTexture) {
                                            vt = this.textureVertices.get(tmpModelElement.getTextureIndex(fp));
                                            this.parent.vertex(v.x, v.y, v.z, vt.x, vt.y);
                                            break block18;
                                        }
                                        this.parent.vertex(v.x, v.y, v.z);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                } else {
                                    this.parent.vertex(v.x, v.y, v.z);
                                }
                            }
                            ++fp;
                        }
                        this.parent.endShape();
                        this.parent.textureMode(2);
                    }
                    ++f;
                }
                ++s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(String filename) {
        this.parseOBJ(this.getBufferedReader(filename));
        if (this.debug.enabled) {
            this.printModelInfo();
        }
    }

    public void scale(float scale) {
        this.scale(scale, scale, scale);
    }

    public void scale(float scaleX, float scaleY, float scaleZ) {
        int vertexCount = this.getVertexCount();
        if (vertexCount == 0) {
            this.debug.println("OBJTransform - \tThe model has no verts. Have you loaded it yet?");
        } else {
            int i = 0;
            while (i < vertexCount) {
                PVector v = this.getVertex(i);
                v.x *= scaleX;
                v.y *= scaleY;
                v.z *= scaleZ;
                ++i;
            }
        }
    }

    public void translate(PVector p) {
        int vertexCount = this.getVertexCount();
        if (vertexCount == 0) {
            this.debug.println("OBJTransform - \tThe model has no verts. Have you loaded it yet?");
        } else {
            PVector m = new PVector(p.x, p.y, p.z);
            m.mult(-1.0f);
            int i = 0;
            while (i < vertexCount) {
                PVector v = this.getVertex(i);
                v.add(m);
                ++i;
            }
        }
    }

    public void translateToCenter() {
        BoundingBox box = new BoundingBox(this.parent, this);
        this.translate(box.getCenter());
    }

    public void mapUVToZeroOne() {
        PVector temp;
        int count = this.getUVCount();
        PVector minimum = new PVector(2.1474836E9f, 2.1474836E9f, 0.0f);
        PVector maximum = new PVector(-2.1474836E9f, -2.1474836E9f, 0.0f);
        int i = 0;
        while (i < count) {
            temp = this.getUV(i);
            minimum.x = PApplet.min(minimum.x, temp.x);
            minimum.y = PApplet.min(minimum.y, temp.y);
            maximum.x = PApplet.max(maximum.x, temp.x);
            maximum.y = PApplet.max(maximum.y, temp.y);
            ++i;
        }
        i = 0;
        while (i < count) {
            temp = this.getUV(i);
            temp.x = PApplet.map(temp.x, minimum.x, maximum.x, 0.0f, 1.0f);
            temp.y = PApplet.map(temp.y, minimum.y, maximum.y, 0.0f, 1.0f);
            ++i;
        }
    }

    public void clampUV() {
        int count = this.getUVCount();
        int i = 0;
        while (i < count) {
            PVector temp = this.getUV(i);
            temp.x = PApplet.constrain(temp.x, 0.0f, 1.0f);
            temp.y = PApplet.constrain(temp.y, 0.0f, 1.0f);
            ++i;
        }
    }

    private BufferedReader getBufferedReader(String filename) {
        this.debug.println("Loading this = " + filename);
        try {
            BufferedReader retval = this.parent.createReader(filename);
            if (retval != null) {
                return retval;
            }
            PApplet.println("Could not find this file " + filename);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseOBJ(BufferedReader bread) {
        block30: {
            try {
                this.groups.put("default", this.defaultGroup);
                currentGroup = this.defaultGroup;
                currentMaterial = this.defaultMaterialName;
                defaultMaterial = new Material();
                defaultMaterial.mtlName = this.defaultMaterialName;
                this.materials.put(this.defaultMaterialName, defaultMaterial);
                this.defaultSegment.materialName = currentMaterial;
                this.segments.add(this.defaultSegment);
                currentGroup.segments.add(this.defaultSegment);
                currentModelSegment = this.defaultSegment;
                line = "";
lbl17:
                // 3 sources

                block2: while (true) {
                    block33: {
                        block32: {
                            block31: {
                                if ((line = bread.readLine()) != null) break block31;
                                i = 0;
                                if (true) ** GOTO lbl154
                            }
                            while (true) {
                                if (!line.contains("\\")) {
                                    elements = line.split("\\s+");
                                    if (elements.length <= 0) continue block2;
                                    if (!elements[0].equals("v")) break;
                                    tmpv = new PVector(Float.valueOf(elements[1]).floatValue(), -Float.valueOf(elements[2]).floatValue(), Float.valueOf(elements[3]).floatValue());
                                    this.vertices.add(tmpv);
                                    continue block2;
                                }
                                s = line = line.split("\\\\")[0];
                                if (s == null) continue;
                                line = String.valueOf(line) + s;
                            }
                            if (elements[0].equals("vn")) {
                                tmpn = new PVector(Float.valueOf(elements[1]).floatValue(), -Float.valueOf(elements[2]).floatValue(), Float.valueOf(elements[3]).floatValue());
                                this.normalVertices.add(tmpn);
                                continue;
                            }
                            if (elements[0].equals("vt")) {
                                tmpv = new PVector(Float.valueOf(elements[1]).floatValue(), 1.0f - Float.valueOf(elements[2]).floatValue());
                                this.textureVertices.add(tmpv);
                                continue;
                            }
                            if (elements[0].equals("o")) {
                                if (elements[1] == null) continue;
                                this.name = elements[1];
                                continue;
                            }
                            if (elements[0].equals("mtllib")) {
                                if (elements[1] == null) continue;
                                this.parseMTL(this.getBufferedReader(elements[1]));
                                continue;
                            }
                            if (!elements[0].equals("g")) break block32;
                            this.debug.println("found group");
                            newModelSegment = new Segment();
                            this.segments.add(newModelSegment);
                            currentModelSegment = newModelSegment;
                            currentModelSegment.materialName = currentMaterial;
                            e = 1;
                            if (true) ** GOTO lbl102
                        }
                        if (elements[0].equals("usemtl")) {
                            newModelSegment = new Segment();
                            this.segments.add(newModelSegment);
                            currentModelSegment = newModelSegment;
                            currentModelSegment.materialName = elements[1];
                            continue;
                        }
                        if (!elements[0].equals("f")) break block33;
                        f = new Face();
                        if (elements.length < 3) {
                            this.debug.println("Warning: potential model data error");
                        }
                        i = 1;
                        if (true) ** GOTO lbl121
                    }
                    if (!elements[0].equals("ll")) continue;
                    f = new Face();
                    f.indexType = 20;
                    if (elements.length < 2) {
                        this.debug.println("Warning: potential model data error");
                    }
                    i = 1;
                    while (true) {
                        if (i >= elements.length) {
                            currentModelSegment.faces.add(f);
                            continue block2;
                        }
                        f.vertexIndices.add(Integer.valueOf(elements[i]));
                        ++i;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                break block30;
            }
            do {
                if (this.groups.get(elements[e]) == null) {
                    this.debug.println("group '" + elements[e] + "'");
                    newGroup = new Group(elements[e]);
                    this.groups.put(elements[e], newGroup);
                }
                ++e;
lbl102:
                // 2 sources

            } while (e < elements.length);
            ** GOTO lbl17
            do {
                if ((seg = elements[i]).indexOf("/") > 0) {
                    forder = seg.split("/");
                    if (forder[0].length() > 0) {
                        f.vertexIndices.add(Integer.valueOf(forder[0]));
                    }
                    if (forder[1].length() > 0) {
                        f.uvIndices.add(Integer.valueOf(forder[1]));
                    }
                    if (forder[2].length() > 0) {
                        f.normalIndices.add(Integer.valueOf(forder[2]));
                    }
                } else if (seg.length() > 0) {
                    f.vertexIndices.add(Integer.valueOf(seg));
                }
                ++i;
lbl121:
                // 2 sources

            } while (i < elements.length);
            currentModelSegment.faces.add(f);
            ** while (true)
            do {
                s = this.segments.get(i);
                j = 0;
                while (j < s.getFaceCount()) {
                    f = s.getFace(j);
                    vtIndex = f.getVertexIndices();
                    nmIndex = f.getNormalIndices();
                    uvIndex = f.getTextureIndices();
                    k = 0;
                    while (k < vtIndex.length) {
                        f.vertices.add(this.vertices.get(vtIndex[k]));
                        ++k;
                    }
                    k = 0;
                    while (k < nmIndex.length) {
                        f.normals.add(this.normalVertices.get(nmIndex[k]));
                        ++k;
                    }
                    k = 0;
                    while (k < uvIndex.length) {
                        f.uvs.add(this.textureVertices.get(uvIndex[k]));
                        ++k;
                    }
                    ++j;
                }
                ++i;
lbl154:
                // 2 sources

            } while (i < this.getSegmentCount());
        }
        i = this.getSegmentCount() - 1;
        while (i >= 0) {
            if (this.getIndexCountInSegment(i) == 0) {
                this.segments.remove(i);
            }
            --i;
        }
    }

    private void parseMTL(BufferedReader bread) {
        try {
            String line = "";
            Material currentMtl = null;
            while ((line = bread.readLine()) != null) {
                String[] elements;
                if ((line = line.trim()).length() <= 0 || (elements = line.split("\\s+")).length <= 0) continue;
                if (elements[0].equals("newmtl")) {
                    Material tmpMtl;
                    this.debug.println("material: \t\t'" + elements[1] + "'");
                    String mtlName = elements[1];
                    currentMtl = tmpMtl = new Material();
                    this.materials.put(mtlName, tmpMtl);
                    continue;
                }
                if (elements[0].equals("map_Kd") && elements.length > 1) {
                    String texname = elements[1];
                    if (this.texturePathMode.equals(ABSOLUTE)) {
                        this.debug.println("texture diffuse \t\t'" + elements[1] + "'");
                    } else if (this.texturePathMode.equals(RELATIVE)) {
                        int p1 = 0;
                        String slash = "\\";
                        while (p1 != -1) {
                            p1 = texname.indexOf(slash);
                            texname = texname.substring(p1 + 1);
                        }
                        this.debug.println("diffuse: \t\t'" + texname + "'");
                    }
                    currentMtl.map_Kd = this.parent.loadImage(texname);
                    this.originalTexture = texname;
                    continue;
                }
                if (elements[0].equals("Ka") && elements.length > 1) {
                    currentMtl.Ka[0] = Float.valueOf(elements[1]).floatValue();
                    currentMtl.Ka[1] = Float.valueOf(elements[2]).floatValue();
                    currentMtl.Ka[2] = Float.valueOf(elements[3]).floatValue();
                    continue;
                }
                if (elements[0].equals("Kd") && elements.length > 1) {
                    currentMtl.Kd[0] = Float.valueOf(elements[1]).floatValue();
                    currentMtl.Kd[1] = Float.valueOf(elements[2]).floatValue();
                    currentMtl.Kd[2] = Float.valueOf(elements[3]).floatValue();
                    continue;
                }
                if (elements[0].equals("Ks") && elements.length > 1) {
                    currentMtl.Ks[0] = Float.valueOf(elements[1]).floatValue();
                    currentMtl.Ks[1] = Float.valueOf(elements[2]).floatValue();
                    currentMtl.Ks[2] = Float.valueOf(elements[3]).floatValue();
                    continue;
                }
                if (!elements[0].equals("d") || elements.length <= 1) continue;
                currentMtl.d = Float.valueOf(elements[1]).floatValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDrawMode(int _drawMode) {
        this.drawMode = _drawMode;
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    public void setTexturePathMode(String _texturePathMode) {
        this.texturePathMode = _texturePathMode;
    }

    public String getTexturePathMode() {
        return this.texturePathMode;
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public Group getGroup(String groupName) {
        return this.groups.get(groupName);
    }

    public Segment getSegment(int _index) {
        return this.segments.get(_index);
    }

    public Face getFaceInSegment(int _segmentIndex, int _faceIndex) {
        return this.segments.get(_segmentIndex).getFace(_faceIndex);
    }

    public int getSegmentCount() {
        return this.segments.size();
    }

    public int getFaceCount() {
        int count = 0;
        int i = 0;
        while (i < this.getSegmentCount()) {
            count += this.getIndexCountInSegment(i);
            ++i;
        }
        return count;
    }

    public PVector[] getFaceVertices(int faceNumber) {
        int segmentNumber = 0;
        int indexNumber = faceNumber;
        while (indexNumber >= this.getIndexCountInSegment(segmentNumber)) {
            indexNumber -= this.getIndexCountInSegment(segmentNumber);
            ++segmentNumber;
        }
        int[] vertindexes = this.getVertexIndicesInSegment(segmentNumber, indexNumber);
        PVector[] tmp = new PVector[vertindexes.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = new PVector();
            tmp[i].set(this.getVertex(vertindexes[i]));
            ++i;
        }
        return tmp;
    }

    public int getIndexCountInSegment(int i) {
        return this.segments.get(i).getFaceCount();
    }

    public int[] getVertexIndicesInSegment(int i, int num) {
        return this.segments.get(i).getFace(num).getVertexIndices();
    }

    public int[] getNormalIndicesInSegment(int i, int num) {
        return this.segments.get(i).getFace(num).getNormalIndices();
    }

    public int[] getTextureIndicesInSegment(int i, int num) {
        return this.segments.get(i).getFace(num).getTextureIndices();
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    public int getNormalCount() {
        return this.normalVertices.size();
    }

    public int getUVCount() {
        return this.textureVertices.size();
    }

    public PVector getVertex(int i) {
        return this.vertices.get(i);
    }

    public PVector getNormal(int i) {
        return this.normalVertices.get(i);
    }

    public PVector getUV(int i) {
        return this.textureVertices.get(i);
    }

    public void setVertex(int i, PVector vertex) {
        this.vertices.get(i).set(vertex);
    }

    public void setVertex(int i, float x, float y, float z) {
        this.vertices.get(i).set(x, y, z);
    }

    public void setNormal(int i, PVector normal) {
        this.normalVertices.get(i).set(normal);
    }

    public void setUV(int i, PVector uv) {
        this.textureVertices.get(i).set(uv);
    }

    public void setTexture(PImage textureName) {
        this.texture = textureName;
    }

    public void texture(PImage tex) {
        this.texture = tex;
        this.debug.println("Using new texture");
    }

    public void originalTexture() {
        this.texture = null;
    }
}

